//***************************************************************************

// Copyright (C) 2009 Realmac Software Ltd
//
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information of Realmac Software Ltd
// and are protected by copyright law. They may not be disclosed
// to third parties or copied or duplicated in any form, in whole or
// in part, without the prior written consent of Realmac Software Ltd.

// Created by Keith Duncan on 29/05/2009

//***************************************************************************

#import <Cocoa/Cocoa.h>

@class CALayer;

@interface NSView (RMAdditions)

/*!
	\brief
	Cache display in an image suitable for animating the view as a whole
	
	\details
	Not suitable for use with a view that uses a surface for rendering such a view with an associated NSOpenGLContext or layer hosting / backed views
 */
- (CGImageRef)CGImageRepresentation;

/*!
	\brief
	If YES then the receiver's layer tree is enumerated and the contentsScale set to the receiver's window's backingScaleFactor
	Scale factor changes are tracked between windows and screens automatically.
 */
@property (assign, nonatomic) BOOL shouldUpdateLayerHierarchyContentsScaleWithWindowBackingScaleFactor;
/*!
	\brief
	Use to traverse a layer hierarchy before you add a layer to the view's layer hierarchy
	
	\details
	Called for the root layer automatically if shouldUpdateLayerContentsScaleWithWindowBackingScaleFactor is set to true
 */
- (void)updateLayerHierarchyContentsScale:(CALayer *)layer;

@end
